/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: NewAndDeleteWin32.cpp,v 1.5 1999/12/20 09:31:50 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"

#include "pgpMem.h"
#include "PGPMemoryMgr.h"

#include "NewAndDelete.h"

_USING_PGP

_UNNAMED_BEGIN

// Class CPGPMemoryMgr

class CPGPMemoryMgr
{
public:
	static void	UpRef();
	static void	DownRef();

	static void *	NewData(PGPSize size)
	{
		return PGPNewData(mManager, size, NULL);
	}

	static void *	NewSecureData(PGPSize size)
	{
		return PGPNewSecureData(mManager, size, kPGPMemoryMgrFlags_Clear);
	}

	static void		FreeData(void *p)
	{
		PGPFreeData(p);
	}

private:
	static PGPMemoryMgrRef	mManager;
	static PGPUInt32		mRefCount;

	static void	CreateManager();
	static void	DestroyManager();
};

// Class CPGPMemoryMgr member functions

void 
CPGPMemoryMgr::UpRef()
{
	if (++mRefCount == 1)
		CreateManager();
}

void 
CPGPMemoryMgr::DownRef()
{
	if ((mRefCount > 0) && (--mRefCount == 0))
		DestroyManager();
}

void 
CPGPMemoryMgr::CreateManager()
{
	pgpAssert(!PGPMemoryMgrRefIsValid(mManager));

	PGPError	pgpErr	= PGPNewMemoryMgr(NULL, &mManager);
	THROW_IF_PGPERROR(pgpErr);

	mRefCount++;
}

void 
CPGPMemoryMgr::DestroyManager()
{
	pgpAssert(PGPMemoryMgrRefIsValid(mManager));

	PGPFreeMemoryMgr(mManager);
	mManager = kInvalidPGPMemoryMgrRef;
}

// Statics

PGPMemoryMgrRef	CPGPMemoryMgr::mManager		= kInvalidPGPMemoryMgrRef;
PGPUInt32		CPGPMemoryMgr::mRefCount	= 0;

// It would be better to have static con/des up and down ref the memory
// manager, but this causes screwups in DLLs because DllMain-time is
// restrictive on what you can and cannot do. Just create and dispose of
// the PFL imp factory or some other piece of memory in your app/dll
// init/cleanup functions and the memory manager won't be recreated and
// redestroyed (which happens when you cycle between 0 and 1 total allocs).

_UNNAMED_END


// Operator new and delete helper functions

void * 
NewAndDelete::NewHelper(size_t size, MemoryType memType, PGPBoolean throws)
{
	if (size == 0)
		size = 1;	// required by standard!

	CPGPMemoryMgr::UpRef();

	void	*p	= NULL;

	if (memType == kSecureMemType)
		p = CPGPMemoryMgr::NewSecureData(size);
	else
		p = CPGPMemoryMgr::NewData(size);

	if (IsNull(p))
	{
		if (throws)
			THROW_PGPERROR(kPGPError_OutOfMemory);
	}
	else
	{
	#if PGP_DEBUG
		pgpDebugWhackMemory(p, size);
	#endif	// PGP_DEBUG
	}

	return p;
};

void 
NewAndDelete::DeleteHelper(void *p)
{
	if (IsntNull(p))
		CPGPMemoryMgr::FreeData(p);

	CPGPMemoryMgr::DownRef();
}
